/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.ItemBase;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCustomSpawnEgg
extends ItemBase {
    public CreatureType creatureType;

    public ItemCustomSpawnEgg(String name, CreatureType creatureType) {
        this.func_77655_b(name);
        this.func_77627_a(true);
        this.func_77637_a(LycanitesMobs.creaturesTab);
        this.itemName = name;
        this.creatureType = creatureType;
        this.setRegistryName(this.modInfo.modid, this.itemName);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBehaviorMobEggCustom());
        LycanitesMobs.logDebug("Creature Type", "Created Creature Type Spawn Egg: " + this.itemName);
    }

    @Override
    public String func_77653_i(ItemStack itemStack) {
        String displayName = LanguageManager.translate("creaturetype.spawn") + " " + this.creatureType.getTitle() + ": ";
        String creatureName = this.getCreatureName(itemStack);
        if (creatureName != null) {
            CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName);
            String creatureTitle = creatureInfo != null ? creatureInfo.getTitle() : LanguageManager.translate("entity." + creatureName + ".name");
            displayName = displayName + creatureTitle;
        }
        return displayName;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String description = this.getDescription(stack, worldIn, tooltip, flagIn);
        if (!"".equalsIgnoreCase(description) && !("item." + this.itemName + ".description").equals(description)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List formattedDescriptionList = fontRenderer.func_78271_c(description, ItemBase.DESCRIPTION_WIDTH);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a7a" + formattedDescription);
            }
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
        if (creatureInfo == null) {
            String creatureName = this.getCreatureName(itemStack);
            LycanitesMobs.logWarning("Mob Spawn Egg", "Unable to get Creature Info for id: " + creatureName);
            return "Unable to get Creature Info for id: '" + creatureName + "' this spawn egg may have been created by a give command without NBT data.";
        }
        return creatureInfo.getDescription();
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EntityLivingBase entity;
        ItemStack itemStack = player.func_184586_b(hand);
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        if (block == Blocks.field_150474_ac) {
            TileEntity tileEntity = world.func_175625_s(pos);
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileEntity).func_145881_a();
            CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
            if (creatureInfo == null) {
                return EnumActionResult.FAIL;
            }
            mobspawnerbaselogic.func_190894_a(creatureInfo.getResourceLocation());
            tileEntity.func_70296_d();
            world.func_184138_a(pos, blockState, blockState, 3);
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && blockState.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = this.spawnCreature(world, itemStack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (itemStack.func_82837_s()) {
                entity.func_96094_a(itemStack.func_82833_r());
            }
            this.applyItemEntityDataToEntity(world, player, itemStack, (Entity)entity);
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
        if (rayTraceResult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.func_178782_a();
            if (!world.canMineBlockBody(player, pos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
            }
            if (!player.func_175151_a(pos, rayTraceResult.field_178784_b, itemStack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
            }
            if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                EntityLivingBase entity = this.spawnCreature(world, itemStack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (entity != null && itemStack.func_82837_s()) {
                    entity.func_96094_a(itemStack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean useItemColors() {
        return true;
    }

    @Override
    public int getColorFromItemstack(ItemStack itemStack, int tintIndex) {
        CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
        return creatureInfo != null ? (tintIndex == 0 ? creatureInfo.eggBackColor : creatureInfo.eggForeColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.modInfo == null || this.creatureType == null || !this.func_194125_a(tab)) {
            return;
        }
        for (CreatureInfo creatureInfo : this.creatureType.creatures.values()) {
            ItemStack itemstack = new ItemStack((Item)this, 1);
            this.applyCreatureInfoToItemStack(itemstack, creatureInfo);
            items.add((Object)itemstack);
        }
    }

    public CreatureInfo getCreatureInfo(ItemStack itemStack) {
        String creatureName = this.getCreatureName(itemStack);
        return CreatureManager.getInstance().getCreature(creatureName);
    }

    public String getCreatureName(ItemStack itemStack) {
        NBTTagCompound itemStackNBT = itemStack.func_77978_p();
        if (itemStackNBT == null || !itemStackNBT.func_150297_b("CreatureInfoSpawnEgg", 10)) {
            return null;
        }
        NBTTagCompound spawnEggNBT = itemStackNBT.func_74775_l("CreatureInfoSpawnEgg");
        return !spawnEggNBT.func_150297_b("creaturename", 8) ? null : spawnEggNBT.func_74779_i("creaturename");
    }

    public EntityLivingBase spawnCreature(World world, ItemStack itemStack, double x, double y, double z) {
        CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
        if (creatureInfo == null) {
            return null;
        }
        EntityLiving entity = creatureInfo.createEntity(world);
        if (entity != null) {
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = entity;
                entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), null);
                entityliving.func_70642_aH();
            }
            world.func_72838_d((Entity)entity);
        }
        return entity;
    }

    public void applyCreatureInfoToItemStack(ItemStack itemStack, CreatureInfo creatureInfo) {
        NBTTagCompound itemStackNBT = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound spawnEggNBT = new NBTTagCompound();
        spawnEggNBT.func_74778_a("creaturename", creatureInfo.getName());
        itemStackNBT.func_74782_a("CreatureInfoSpawnEgg", (NBTBase)spawnEggNBT);
        itemStack.func_77982_d(itemStackNBT);
    }

    public void applyItemEntityDataToEntity(World entityWorld, EntityPlayer player, ItemStack stack, Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("CreatureInfoSpawnEgg", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound entityNBT = new NBTTagCompound();
            targetEntity.func_189511_e(entityNBT);
            UUID uuid = targetEntity.func_110124_au();
            entityNBT.func_179237_a(nbttagcompound.func_74775_l("CreatureInfoSpawnEgg"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(entityNBT);
        }
    }
}

